<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Student\AuthController;

/*
|--------------------------------------------------------------------------
| Student Routes
|--------------------------------------------------------------------------
| All routes accessible to students
*/

// Public routes (no authentication required)
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected routes (JWT authentication required)
Route::middleware('auth:student')->group(function () {

    // Profile Management
    Route::get('/profile', [AuthController::class, 'profile']);
    Route::put('/profile', [AuthController::class, 'updateProfile']);
    Route::post('/change-password', [AuthController::class, 'changePassword']);

    // Token Management
    Route::post('/refresh', [AuthController::class, 'refresh']);
    Route::post('/logout', [AuthController::class, 'logout']);

    // Dashboard
    // Route::get('/dashboard', [StudentDashboardController::class, 'index']);

    // Academic Information
    // Route::get('/class-info', [StudentClassController::class, 'info']);
    // Route::get('/subjects', [StudentSubjectController::class, 'index']);
    // Route::get('/timetable', [StudentTimetableController::class, 'index']);

    // Attendance
    // Route::get('/attendance', [StudentAttendanceController::class, 'index']);
    // Route::get('/attendance/summary', [StudentAttendanceController::class, 'summary']);
    // Route::get('/attendance/monthly', [StudentAttendanceController::class, 'monthly']);

    // Exams & Results
    // Route::get('/exams', [StudentExamController::class, 'index']);
    // Route::get('/exams/{id}', [StudentExamController::class, 'show']);
    // Route::get('/results', [StudentResultController::class, 'index']);
    // Route::get('/results/{exam_id}', [StudentResultController::class, 'show']);
    // Route::get('/marksheet/{exam_id}', [StudentResultController::class, 'marksheet']);

    // Homework & Assignments
    // Route::get('/homework', [StudentHomeworkController::class, 'index']);
    // Route::get('/homework/{id}', [StudentHomeworkController::class, 'show']);
    // Route::post('/homework/{id}/submit', [StudentHomeworkController::class, 'submit']);
    // Route::get('/assignments', [StudentAssignmentController::class, 'index']);

    // Fee Management
    // Route::get('/fees', [StudentFeeController::class, 'index']);
    // Route::get('/fees/pending', [StudentFeeController::class, 'pending']);
    // Route::get('/fees/paid', [StudentFeeController::class, 'paid']);
    // Route::get('/fees/receipt/{id}', [StudentFeeController::class, 'receipt']);

    // Library
    // Route::get('/library/issued-books', [StudentLibraryController::class, 'issuedBooks']);
    // Route::get('/library/search', [StudentLibraryController::class, 'search']);
    // Route::post('/library/reserve', [StudentLibraryController::class, 'reserve']);

    // Transport
    // Route::get('/transport', [StudentTransportController::class, 'info']);
    // Route::get('/transport/route', [StudentTransportController::class, 'route']);

    // Notices & Announcements
    // Route::get('/notices', [StudentNoticeController::class, 'index']);
    // Route::get('/notices/{id}', [StudentNoticeController::class, 'show']);
    // Route::get('/announcements', [StudentAnnouncementController::class, 'index']);

    // Leave Applications
    // Route::get('/leave-applications', [StudentLeaveController::class, 'index']);
    // Route::post('/leave-applications', [StudentLeaveController::class, 'store']);
    // Route::get('/leave-applications/{id}', [StudentLeaveController::class, 'show']);

    // Events & Calendar
    // Route::get('/events', [StudentEventController::class, 'index']);
    // Route::get('/calendar', [StudentCalendarController::class, 'index']);

    // Documents
    // Route::get('/documents', [StudentDocumentController::class, 'index']);
    // Route::get('/documents/{id}/download', [StudentDocumentController::class, 'download']);

    // Online Classes (LMS)
    // Route::get('/courses', [StudentCourseController::class, 'index']);
    // Route::get('/courses/{id}', [StudentCourseController::class, 'show']);
    // Route::get('/lessons/{id}', [StudentLessonController::class, 'show']);

    // Online Exams
    // Route::get('/online-exams', [StudentOnlineExamController::class, 'index']);
    // Route::post('/online-exams/{id}/start', [StudentOnlineExamController::class, 'start']);
    // Route::post('/online-exams/{id}/submit', [StudentOnlineExamController::class, 'submit']);

    // Sports & Activities
    // Route::get('/sports', [StudentSportsController::class, 'index']);
    // Route::get('/achievements', [StudentAchievementController::class, 'index']);
});
