<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Parent\AuthController;

/*
|--------------------------------------------------------------------------
| Parent Routes
|--------------------------------------------------------------------------
| All routes accessible to parents/guardians
*/

// Public routes (no authentication required)
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected routes (JWT authentication required)
Route::middleware('auth:parent')->group(function () {

    // Profile Management
    Route::get('/profile', [AuthController::class, 'profile']);
    Route::put('/profile', [AuthController::class, 'updateProfile']);
    Route::post('/change-password', [AuthController::class, 'changePassword']);

    // Token Management
    Route::post('/refresh', [AuthController::class, 'refresh']);
    Route::post('/logout', [AuthController::class, 'logout']);

    // Dashboard
    // Route::get('/dashboard', [ParentDashboardController::class, 'index']);

    // Children Management
    // Route::get('/children', [ParentChildrenController::class, 'index']);
    // Route::get('/children/{id}', [ParentChildrenController::class, 'show']);
    // Route::get('/children/{id}/profile', [ParentChildrenController::class, 'profile']);

    // Children's Attendance
    // Route::get('/children/{id}/attendance', [ParentAttendanceController::class, 'index']);
    // Route::get('/children/{id}/attendance/summary', [ParentAttendanceController::class, 'summary']);
    // Route::get('/children/{id}/attendance/monthly', [ParentAttendanceController::class, 'monthly']);

    // Children's Academic Performance
    // Route::get('/children/{id}/subjects', [ParentAcademicController::class, 'subjects']);
    // Route::get('/children/{id}/timetable', [ParentAcademicController::class, 'timetable']);
    // Route::get('/children/{id}/exams', [ParentExamController::class, 'index']);
    // Route::get('/children/{id}/results', [ParentResultController::class, 'index']);
    // Route::get('/children/{id}/results/{exam_id}', [ParentResultController::class, 'show']);
    // Route::get('/children/{id}/marksheet/{exam_id}', [ParentResultController::class, 'marksheet']);

    // Children's Homework
    // Route::get('/children/{id}/homework', [ParentHomeworkController::class, 'index']);
    // Route::get('/children/{id}/homework/{homework_id}', [ParentHomeworkController::class, 'show']);

    // Fee Management
    // Route::get('/children/{id}/fees', [ParentFeeController::class, 'index']);
    // Route::get('/children/{id}/fees/pending', [ParentFeeController::class, 'pending']);
    // Route::get('/children/{id}/fees/paid', [ParentFeeController::class, 'paid']);
    // Route::post('/children/{id}/fees/pay', [ParentFeeController::class, 'pay']);
    // Route::get('/children/{id}/fees/receipt/{transaction_id}', [ParentFeeController::class, 'receipt']);

    // Communication with School
    // Route::get('/messages', [ParentMessageController::class, 'index']);
    // Route::post('/messages', [ParentMessageController::class, 'send']);
    // Route::get('/messages/{id}', [ParentMessageController::class, 'show']);

    // Teacher Communication
    // Route::get('/teachers', [ParentTeacherController::class, 'index']);
    // Route::post('/teachers/{id}/message', [ParentTeacherController::class, 'sendMessage']);

    // Parent-Teacher Meetings
    // Route::get('/meetings', [ParentMeetingController::class, 'index']);
    // Route::post('/meetings/{id}/book', [ParentMeetingController::class, 'book']);
    // Route::get('/meetings/{id}', [ParentMeetingController::class, 'show']);

    // Feedback
    // Route::get('/feedback', [ParentFeedbackController::class, 'index']);
    // Route::post('/feedback', [ParentFeedbackController::class, 'store']);

    // Children's Leave Applications
    // Route::get('/children/{id}/leave-applications', [ParentLeaveController::class, 'index']);
    // Route::post('/children/{id}/leave-applications', [ParentLeaveController::class, 'store']);
    // Route::get('/children/{id}/leave-applications/{leave_id}', [ParentLeaveController::class, 'show']);

    // Transport Information
    // Route::get('/children/{id}/transport', [ParentTransportController::class, 'info']);
    // Route::get('/children/{id}/transport/tracking', [ParentTransportController::class, 'tracking']);

    // Library
    // Route::get('/children/{id}/library/issued-books', [ParentLibraryController::class, 'issuedBooks']);

    // Notices & Announcements
    // Route::get('/notices', [ParentNoticeController::class, 'index']);
    // Route::get('/notices/{id}', [ParentNoticeController::class, 'show']);
    // Route::get('/announcements', [ParentAnnouncementController::class, 'index']);

    // Events & Calendar
    // Route::get('/events', [ParentEventController::class, 'index']);
    // Route::get('/calendar', [ParentCalendarController::class, 'index']);

    // Children's Documents
    // Route::get('/children/{id}/documents', [ParentDocumentController::class, 'index']);
    // Route::get('/children/{id}/documents/{doc_id}/download', [ParentDocumentController::class, 'download']);

    // Children's Health & Fitness
    // Route::get('/children/{id}/health', [ParentHealthController::class, 'index']);
    // Route::get('/children/{id}/fitness-records', [ParentHealthController::class, 'fitnessRecords']);

    // Progress Reports
    // Route::get('/children/{id}/progress-report', [ParentReportController::class, 'progress']);
    // Route::get('/children/{id}/overall-performance', [ParentReportController::class, 'overall']);

    // Complaints & Grievances
    // Route::get('/complaints', [ParentComplaintController::class, 'index']);
    // Route::post('/complaints', [ParentComplaintController::class, 'store']);
    // Route::get('/complaints/{id}', [ParentComplaintController::class, 'show']);
});
