<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
| Here is where you can register API routes for your application.
| Routes are loaded by the RouteServiceProvider and assigned to the
| "api" middleware group.
*/

// API Root - Health Check
Route::get('/', function () {
    return response()->json([
        'success' => true,
        'message' => 'School ERP API - JWT Authentication',
        'version' => '1.0.0',
        'documentation' => 'https://api.school-erp.com/docs',
        'endpoints' => [
            'admin' => '/api/admin',
            'student' => '/api/student',
            'parent' => '/api/parent',
            'public' => '/api/public',
        ],
        'authentication' => 'JWT (JSON Web Token)',
        'guards' => [
            'admin' => 'Admin, Teachers, Staff, Principal',
            'student' => 'Students',
            'parent' => 'Parents/Guardians',
        ],
    ]);
});

/*
|--------------------------------------------------------------------------
| Public CMS Routes
|--------------------------------------------------------------------------
| These routes are publicly accessible without authentication
| Used for website content, admissions, news, events, etc.
*/
Route::prefix('public')->group(function () {
    require __DIR__.'/public.php';
});

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
| Routes for Admin, Teachers, Staff, and Principal users
| Prefix: /api/admin
*/
Route::prefix('admin')->group(function () {
    require __DIR__.'/admin.php';
});

/*
|--------------------------------------------------------------------------
| Student Routes
|--------------------------------------------------------------------------
| Routes accessible to students
| Prefix: /api/student
*/
Route::prefix('student')->group(function () {
    require __DIR__.'/student.php';
});

/*
|--------------------------------------------------------------------------
| Parent Routes
|--------------------------------------------------------------------------
| Routes accessible to parents/guardians
| Prefix: /api/parent
*/
Route::prefix('parent')->group(function () {
    require __DIR__.'/parent.php';
});

/*
|--------------------------------------------------------------------------
| Common/Shared Routes (Optional)
|--------------------------------------------------------------------------
| Routes that might be shared across different user types
*/

// File Upload/Download
// Route::middleware(['auth:admin,student,parent'])->group(function () {
//     Route::post('/upload', [FileController::class, 'upload']);
//     Route::get('/download/{id}', [FileController::class, 'download']);
// });

// Notifications
// Route::middleware(['auth:admin,student,parent'])->group(function () {
//     Route::get('/notifications', [NotificationController::class, 'index']);
//     Route::post('/notifications/{id}/read', [NotificationController::class, 'markAsRead']);
//     Route::post('/notifications/read-all', [NotificationController::class, 'markAllAsRead']);
// });

/*
|--------------------------------------------------------------------------
| Fallback Route
|--------------------------------------------------------------------------
| Return 404 for undefined routes
*/
Route::fallback(function () {
    return response()->json([
        'success' => false,
        'message' => 'Route not found',
        'status' => 404,
    ], 404);
});
