<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\Api\Admin\AuthController;
use App\Http\Controllers\Api\Admin\DashboardController;
use App\Http\Controllers\Api\Admin\StudentController;
use App\Http\Controllers\Api\Admin\TeacherController;
use App\Http\Controllers\Api\Admin\ClassController;
use App\Http\Controllers\Api\Admin\SectionController;
use App\Http\Controllers\Api\Admin\SubjectController;
use App\Http\Controllers\Api\Admin\ExamController;
use App\Http\Controllers\Api\Admin\FeeStructureController;
use App\Http\Controllers\Api\Admin\FeeTransactionController;
use App\Http\Controllers\Api\Admin\FeeReportController;
use App\Http\Controllers\Api\Admin\AttendanceController;
use App\Http\Controllers\Api\Admin\BookController;
use App\Http\Controllers\Api\Admin\VehicleController;
use App\Http\Controllers\Api\Admin\HostelController;
use App\Http\Controllers\Api\Admin\NoticeController;
use App\Http\Controllers\Api\Admin\AnnouncementController;
use App\Http\Controllers\Api\Admin\CommunicationController;
use App\Http\Controllers\Api\Admin\SettingController;
use App\Http\Controllers\Api\Admin\UserController;
use App\Http\Controllers\Api\Admin\RoleController;
use App\Http\Controllers\Api\Admin\PermissionController;
use App\Http\Controllers\Api\Admin\ReportController;
use App\Http\Controllers\Api\Admin\TimetableController;

/*
|--------------------------------------------------------------------------
| Admin Routes
|--------------------------------------------------------------------------
| All routes for Admin, Teachers, Staff, and Principal users
| Complete CRUD operations with pagination and search functionality
*/

// Public routes (no authentication required)
Route::post('/register', [AuthController::class, 'register']);
Route::post('/login', [AuthController::class, 'login']);

// Protected routes (JWT authentication required)
Route::middleware('auth:admin')->group(function () {

    // ========================================
    // Profile Management
    // ========================================
    Route::get('/profile', [AuthController::class, 'profile']);
    Route::put('/profile', [AuthController::class, 'updateProfile']);
    Route::post('/change-password', [AuthController::class, 'changePassword']);

    // Token Management
    Route::post('/refresh', [AuthController::class, 'refresh']);
    Route::post('/logout', [AuthController::class, 'logout']);

    // ========================================
    // Dashboard
    // ========================================
    Route::get('/dashboard', [DashboardController::class, 'index']);

    // ========================================
    // Student Management
    // ========================================
    // GET    /students               - List all students with pagination & search
    // POST   /students               - Create new student
    // GET    /students/{id}          - Get student details
    // PUT    /students/{id}          - Update student
    // DELETE /students/{id}          - Delete student
    Route::apiResource('students', StudentController::class);

    // Additional student routes
    Route::get('students/{id}/attendance', [StudentController::class, 'attendance']);
    Route::get('students/{id}/marks', [StudentController::class, 'marks']);

    // ========================================
    // Teacher Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('teachers', TeacherController::class);
    Route::get('teachers/{id}/schedule', [TeacherController::class, 'schedule']);

    // ========================================
    // Class, Section, Subject Management
    // ========================================
    // Complete CRUD operations with pagination & search
    Route::apiResource('classes', ClassController::class);
    Route::apiResource('sections', SectionController::class);
    Route::apiResource('subjects', SubjectController::class);

    // ========================================
    // Exam Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('exams', ExamController::class);
    Route::post('exams/{id}/publish-results', [ExamController::class, 'publishResults']);

    // ========================================
    // Fee Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('fee-structures', FeeStructureController::class);

    // Fee Transactions - Complete CRUD with pagination & search
    // GET    /fee-transactions                          - List all transactions with filters
    // POST   /fee-transactions                          - Create new transaction
    // GET    /fee-transactions/{id}                     - Get transaction details
    // PUT    /fee-transactions/{id}                     - Update transaction
    // DELETE /fee-transactions/{id}                     - Delete transaction
    Route::apiResource('fee-transactions', FeeTransactionController::class);
    Route::get('fee-transactions/student/{studentId}/history', [FeeTransactionController::class, 'studentHistory']);
    Route::get('fee-transactions/{id}/receipt', [FeeTransactionController::class, 'generateReceipt']);

    // Fee Reports - Comprehensive reporting with multiple report types
    // GET /fee-reports?report_type=summary&start_date=2024-01-01&end_date=2024-12-31
    // Available report types: summary, detailed, class_wise, defaulters, collection
    Route::get('fee-reports', [FeeReportController::class, 'index']);
    Route::post('fee-reports/export', [FeeReportController::class, 'export']);

    // ========================================
    // Attendance Management
    // ========================================
    Route::post('attendance/mark', [AttendanceController::class, 'mark']);
    Route::get('attendance/report', [AttendanceController::class, 'report']);
    Route::get('attendance/statistics', [AttendanceController::class, 'statistics']);

    // ========================================
    // Timetable Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('timetables', TimetableController::class);

    // Additional timetable routes
    Route::get('timetables/class/view', [TimetableController::class, 'getByClass']);
    Route::get('timetables/teacher/view', [TimetableController::class, 'getByTeacher']);
    Route::get('timetables/weekly/view', [TimetableController::class, 'weeklyView']);
    Route::post('timetables/bulk/create', [TimetableController::class, 'bulkCreate']);
    Route::post('timetables/clone', [TimetableController::class, 'clone']);
    Route::post('timetables/conflict/check', [TimetableController::class, 'checkConflict']);
    Route::delete('timetables/class/delete', [TimetableController::class, 'deleteByClass']);

    // ========================================
    // Library Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('books', BookController::class);
    Route::post('books/issue', [BookController::class, 'issue']);
    Route::post('books/return', [BookController::class, 'returnBook']);

    // ========================================
    // Transport Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('vehicles', VehicleController::class);

    // Routes (future implementation)
    // Route::apiResource('routes', TransportRouteController::class);

    // ========================================
    // Hostel Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('hostels', HostelController::class);
    Route::post('hostels/allocate', [HostelController::class, 'allocate']);

    // ========================================
    // Comprehensive Reports
    // ========================================
    // Student Reports - Multiple report types
    // GET /reports/students?report_type=list|performance|demographic|attendance_summary|fee_summary|promotion|transfer
    Route::get('reports/students', [ReportController::class, 'students']);

    // Attendance Reports - Multiple report types
    // GET /reports/attendance?report_type=daily|monthly|class_wise|student_wise|defaulters
    Route::get('reports/attendance', [ReportController::class, 'attendance']);

    // Exam Results Reports - Multiple report types
    // GET /reports/exam-results?report_type=exam_wise|student_wise|class_wise|subject_wise|toppers|failures
    Route::get('reports/exam-results', [ReportController::class, 'examResults']);

    // ========================================
    // Communication
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('notices', NoticeController::class);
    Route::apiResource('announcements', AnnouncementController::class);

    // SMS & Email Communication
    Route::post('send-sms', [CommunicationController::class, 'sendSms']);
    Route::post('send-email', [CommunicationController::class, 'sendEmail']);
    Route::get('communication/history', [CommunicationController::class, 'history']);

    // ========================================
    // System Settings
    // ========================================
    // GET    /settings                    - Get all settings (optional ?category=general)
    // PUT    /settings                    - Update settings by category
    // GET    /settings/{category}/{key}   - Get single setting
    // PUT    /settings/{category}/{key}   - Update single setting
    Route::get('settings', [SettingController::class, 'index']);
    Route::put('settings', [SettingController::class, 'update']);
    Route::post('settings/reset', [SettingController::class, 'reset']);
    Route::get('settings/{category}/{key}', [SettingController::class, 'show']);
    Route::put('settings/{category}/{key}', [SettingController::class, 'updateSingle']);

    // ========================================
    // User & Role Management
    // ========================================
    // Complete CRUD with pagination & search
    Route::apiResource('users', UserController::class);
    Route::post('users/{id}/toggle-status', [UserController::class, 'toggleStatus']);
    Route::post('users/{id}/reset-password', [UserController::class, 'resetPassword']);

    // Role Management
    Route::apiResource('roles', RoleController::class);
    Route::post('roles/{id}/assign-permissions', [RoleController::class, 'assignPermissions']);
    Route::post('roles/{id}/clone', [RoleController::class, 'clone']);

    // Permission Management
    Route::apiResource('permissions', PermissionController::class);
    Route::get('permissions-modules', [PermissionController::class, 'modules']);
});
