<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TeamPlayer extends Model
{
    use HasFactory;

    protected $fillable = [
        'sports_team_id',
        'sports_player_id',
        'jersey_number',
        'position',
        'is_captain',
        'joined_date',
        'left_date',
        'is_active',
    ];

    protected $casts = [
        'joined_date' => 'date',
        'left_date' => 'date',
        'is_captain' => 'boolean',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function team()
    {
        return $this->belongsTo(SportsTeam::class, 'sports_team_id');
    }

    public function player()
    {
        return $this->belongsTo(SportsPlayer::class, 'sports_player_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeCaptains($query)
    {
        return $query->where('is_captain', true);
    }

    public function scopeForTeam($query, $teamId)
    {
        return $query->where('sports_team_id', $teamId);
    }

    public function scopeForPlayer($query, $playerId)
    {
        return $query->where('sports_player_id', $playerId);
    }
}
