<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class TeacherLessonTopic extends Model
{
    use HasFactory;

    protected $fillable = [
        'lesson_plan_id',
        'topic_name',
        'description',
        'duration_minutes',
        'teaching_method',
        'is_completed',
        'completion_date',
    ];

    protected $casts = [
        'duration_minutes' => 'integer',
        'is_completed' => 'boolean',
        'completion_date' => 'date',
    ];

    // Relationships
    public function lessonPlan()
    {
        return $this->belongsTo(TeacherLessonPlan::class, 'lesson_plan_id');
    }

    // Scopes
    public function scopeForLessonPlan($query, $lessonPlanId)
    {
        return $query->where('lesson_plan_id', $lessonPlanId);
    }

    public function scopeCompleted($query)
    {
        return $query->where('is_completed', true);
    }

    public function scopePending($query)
    {
        return $query->where('is_completed', false);
    }
}
