<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StudentTransport extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'student_id',
        'transport_route_id',
        'route_stop_id',
        'pickup_time',
        'drop_time',
        'monthly_fee',
        'start_date',
        'end_date',
        'is_active',
    ];

    protected $casts = [
        'start_date' => 'date',
        'end_date' => 'date',
        'monthly_fee' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function transportRoute()
    {
        return $this->belongsTo(TransportRoute::class, 'transport_route_id');
    }

    public function routeStop()
    {
        return $this->belongsTo(RouteStop::class, 'route_stop_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeForStudent($query, $studentId)
    {
        return $query->where('student_id', $studentId);
    }

    public function scopeForRoute($query, $routeId)
    {
        return $query->where('transport_route_id', $routeId);
    }

    public function scopeForStop($query, $stopId)
    {
        return $query->where('route_stop_id', $stopId);
    }
}
