<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StaffTaxDeclaration extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'staff_id',
        'financial_year',
        'section',
        'investment_type',
        'amount',
        'proof_document',
        'declaration_date',
        'verification_status',
        'verified_by',
        'verification_date',
        'remarks',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'declaration_date' => 'date',
        'verification_date' => 'date',
    ];

    // Relationships
    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    public function verifiedBy()
    {
        return $this->belongsTo(User::class, 'verified_by');
    }

    // Scopes
    public function scopeForStaff($query, $staffId)
    {
        return $query->where('staff_id', $staffId);
    }

    public function scopeForFinancialYear($query, $year)
    {
        return $query->where('financial_year', $year);
    }

    public function scopeVerified($query)
    {
        return $query->where('verification_status', 'verified');
    }

    public function scopePending($query)
    {
        return $query->where('verification_status', 'pending');
    }

    public function scopeBySection($query, $section)
    {
        return $query->where('section', $section);
    }

    // Accessors
    public function getIsVerifiedAttribute()
    {
        return $this->verification_status === 'verified';
    }
}
