<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class StaffQualification extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'staff_id',
        'qualification_type',
        'degree_name',
        'institution_name',
        'board_university',
        'year_of_passing',
        'percentage_cgpa',
        'specialization',
        'certificate_file',
        'remarks',
    ];

    protected $casts = [
        'year_of_passing' => 'integer',
        'percentage_cgpa' => 'decimal:2',
    ];

    // Relationships
    public function staff()
    {
        return $this->belongsTo(Staff::class);
    }

    // Scopes
    public function scopeForStaff($query, $staffId)
    {
        return $query->where('staff_id', $staffId);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('qualification_type', $type);
    }

    public function scopeByYear($query, $year)
    {
        return $query->where('year_of_passing', $year);
    }
}
