<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SportsAchievement extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'school_id',
        'sport_id',
        'player_id',
        'team_id',
        'tournament_id',
        'achievement_title',
        'achievement_type',
        'position',
        'achievement_date',
        'description',
        'certificate_file',
    ];

    protected $casts = [
        'achievement_date' => 'date',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function sport()
    {
        return $this->belongsTo(Sport::class);
    }

    public function player()
    {
        return $this->belongsTo(SportsPlayer::class, 'player_id');
    }

    public function team()
    {
        return $this->belongsTo(SportsTeam::class, 'team_id');
    }

    public function tournament()
    {
        return $this->belongsTo(SportsTournament::class, 'tournament_id');
    }

    // Scopes
    public function scopeForSport($query, $sportId)
    {
        return $query->where('sport_id', $sportId);
    }

    public function scopeForPlayer($query, $playerId)
    {
        return $query->where('player_id', $playerId);
    }

    public function scopeForTeam($query, $teamId)
    {
        return $query->where('team_id', $teamId);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('achievement_type', $type);
    }
}
