<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Sport extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'school_id',
        'name',
        'description',
        'category',
        'sport_type',
        'max_players_per_team',
        'min_players_per_team',
        'is_active',
    ];

    protected $casts = [
        'max_players_per_team' => 'integer',
        'min_players_per_team' => 'integer',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function teams()
    {
        return $this->hasMany(SportsTeam::class, 'sport_id');
    }

    public function matches()
    {
        return $this->hasMany(SportsMatch::class, 'sport_id');
    }

    public function tournaments()
    {
        return $this->hasMany(SportsTournament::class, 'sport_id');
    }

    public function achievements()
    {
        return $this->hasMany(SportsAchievement::class, 'sport_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByCategory($query, $category)
    {
        return $query->where('category', $category);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('sport_type', $type);
    }
}
