<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class SalaryTemplateDetail extends Model
{
    use HasFactory;

    protected $fillable = [
        'salary_template_id',
        'salary_head_id',
        'component_type',
        'amount',
        'is_percentage',
        'percentage_value',
        'is_taxable',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'is_percentage' => 'boolean',
        'percentage_value' => 'decimal:2',
        'is_taxable' => 'boolean',
    ];

    // Relationships
    public function salaryTemplate()
    {
        return $this->belongsTo(SalaryTemplate::class, 'salary_template_id');
    }

    public function salaryHead()
    {
        return $this->belongsTo(SalaryHead::class, 'salary_head_id');
    }

    // Scopes
    public function scopeAllowances($query)
    {
        return $query->where('component_type', 'allowance');
    }

    public function scopeDeductions($query)
    {
        return $query->where('component_type', 'deduction');
    }

    public function scopeTaxable($query)
    {
        return $query->where('is_taxable', true);
    }
}
