<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class SalaryHead extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'school_id',
        'head_name',
        'head_code',
        'head_type',
        'description',
        'is_taxable',
        'is_active',
    ];

    protected $casts = [
        'is_taxable' => 'boolean',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function templateDetails()
    {
        return $this->hasMany(SalaryTemplateDetail::class, 'salary_head_id');
    }

    public function payslipItems()
    {
        return $this->hasMany(PayslipItem::class, 'salary_head_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeAllowances($query)
    {
        return $query->where('head_type', 'allowance');
    }

    public function scopeDeductions($query)
    {
        return $query->where('head_type', 'deduction');
    }

    public function scopeTaxable($query)
    {
        return $query->where('is_taxable', true);
    }
}
