<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class QuestionOption extends Model
{
    use HasFactory;

    protected $fillable = [
        'question_id',
        'option_text',
        'option_image',
        'is_correct',
        'option_order',
    ];

    protected $casts = [
        'is_correct' => 'boolean',
        'option_order' => 'integer',
    ];

    // Relationships
    public function question()
    {
        return $this->belongsTo(QuestionBank::class, 'question_id');
    }

    // Scopes
    public function scopeCorrect($query)
    {
        return $query->where('is_correct', true);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('option_order');
    }
}
