<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PhoneCallLog extends Model
{
    use HasFactory;

    protected $fillable = [
        'school_id',
        'caller_name',
        'caller_phone',
        'receiver_name',
        'receiver_phone',
        'call_date',
        'call_time',
        'call_duration',
        'call_type',
        'purpose',
        'description',
        'follow_up_required',
        'follow_up_date',
        'logged_by',
    ];

    protected $casts = [
        'call_date' => 'date',
        'call_time' => 'datetime',
        'follow_up_date' => 'date',
        'call_duration' => 'integer',
        'follow_up_required' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function loggedBy()
    {
        return $this->belongsTo(User::class, 'logged_by');
    }

    // Scopes
    public function scopeForDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('call_date', [$startDate, $endDate]);
    }

    public function scopeByCallType($query, $type)
    {
        return $query->where('call_type', $type);
    }

    public function scopeFollowUpRequired($query)
    {
        return $query->where('follow_up_required', true)
                     ->whereNull('follow_up_date')
                     ->orWhere('follow_up_date', '>=', now());
    }
}
