<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Period extends Model
{
    use HasFactory;

    protected $fillable = [
        'school_id',
        'name',
        'period_number',
        'start_time',
        'end_time',
        'is_break',
        'is_active',
    ];

    protected $casts = [
        'start_time' => 'datetime',
        'end_time' => 'datetime',
        'period_number' => 'integer',
        'is_break' => 'boolean',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function timetables()
    {
        return $this->hasMany(Timetable::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeBreaks($query)
    {
        return $query->where('is_break', true);
    }

    public function scopeClasses($query)
    {
        return $query->where('is_break', false);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('period_number');
    }

    // Accessors
    public function getDurationInMinutesAttribute()
    {
        return $this->start_time->diffInMinutes($this->end_time);
    }
}
