<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class PayslipItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'payslip_id',
        'salary_head_id',
        'item_type',
        'amount',
        'is_taxable',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'is_taxable' => 'boolean',
    ];

    // Relationships
    public function payslip()
    {
        return $this->belongsTo(Payslip::class, 'payslip_id');
    }

    public function salaryHead()
    {
        return $this->belongsTo(SalaryHead::class, 'salary_head_id');
    }

    // Scopes
    public function scopeAllowances($query)
    {
        return $query->where('item_type', 'allowance');
    }

    public function scopeDeductions($query)
    {
        return $query->where('item_type', 'deduction');
    }

    public function scopeTaxable($query)
    {
        return $query->where('is_taxable', true);
    }
}
