<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class OnlineExamQuestion extends Model
{
    use HasFactory;

    protected $fillable = [
        'online_exam_id',
        'question_bank_id',
        'question_order',
        'marks',
    ];

    protected $casts = [
        'question_order' => 'integer',
        'marks' => 'decimal:2',
    ];

    // Relationships
    public function onlineExam()
    {
        return $this->belongsTo(OnlineExam::class, 'online_exam_id');
    }

    public function questionBank()
    {
        return $this->belongsTo(QuestionBank::class, 'question_bank_id');
    }

    // Scopes
    public function scopeForExam($query, $examId)
    {
        return $query->where('online_exam_id', $examId);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('question_order');
    }
}
