<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LoginHistory extends Model
{
    use HasFactory;

    protected $table = 'login_history';

    protected $fillable = [
        'user_id',
        'login_time',
        'logout_time',
        'ip_address',
        'user_agent',
        'device_type',
        'browser',
        'platform',
        'location',
        'status',
        'failure_reason',
    ];

    protected $casts = [
        'login_time' => 'datetime',
        'logout_time' => 'datetime',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scopes
    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function scopeSuccessful($query)
    {
        return $query->where('status', 'success');
    }

    public function scopeFailed($query)
    {
        return $query->where('status', 'failed');
    }

    public function scopeForDateRange($query, $startDate, $endDate)
    {
        return $query->whereBetween('login_time', [$startDate, $endDate]);
    }

    public function scopeActive($query)
    {
        return $query->whereNull('logout_time');
    }

    // Accessors
    public function getSessionDurationMinutesAttribute()
    {
        if (!$this->logout_time) {
            return null;
        }
        return $this->login_time->diffInMinutes($this->logout_time);
    }
}
