<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LmsTopic extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'lesson_id',
        'title',
        'description',
        'content',
        'topic_order',
        'video_url',
        'attachments',
        'duration_minutes',
        'is_published',
    ];

    protected $casts = [
        'topic_order' => 'integer',
        'duration_minutes' => 'integer',
        'attachments' => 'array',
        'is_published' => 'boolean',
    ];

    // Relationships
    public function lesson()
    {
        return $this->belongsTo(LmsLesson::class, 'lesson_id');
    }

    // Scopes
    public function scopePublished($query)
    {
        return $query->where('is_published', true);
    }

    public function scopeForLesson($query, $lessonId)
    {
        return $query->where('lesson_id', $lessonId);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('topic_order');
    }
}
