<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class LmsLesson extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'course_id',
        'title',
        'description',
        'lesson_order',
        'content',
        'video_url',
        'document_url',
        'duration_minutes',
        'is_published',
    ];

    protected $casts = [
        'lesson_order' => 'integer',
        'duration_minutes' => 'integer',
        'is_published' => 'boolean',
    ];

    // Relationships
    public function course()
    {
        return $this->belongsTo(LmsCourse::class, 'course_id');
    }

    public function topics()
    {
        return $this->hasMany(LmsTopic::class, 'lesson_id');
    }

    // Scopes
    public function scopePublished($query)
    {
        return $query->where('is_published', true);
    }

    public function scopeForCourse($query, $courseId)
    {
        return $query->where('course_id', $courseId);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('lesson_order');
    }

    // Accessors
    public function getHasVideoAttribute()
    {
        return !empty($this->video_url);
    }

    public function getHasDocumentAttribute()
    {
        return !empty($this->document_url);
    }
}
