<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class LeaveType extends Model
{
    use HasFactory;

    protected $fillable = [
        'school_id',
        'name',
        'code',
        'description',
        'max_days_per_year',
        'requires_approval',
        'applicable_for',
        'is_active',
    ];

    protected $casts = [
        'max_days_per_year' => 'integer',
        'requires_approval' => 'boolean',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function leaveApplications()
    {
        return $this->hasMany(LeaveApplication::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeForStudents($query)
    {
        return $query->where('applicable_for', 'students')
                     ->orWhere('applicable_for', 'both');
    }

    public function scopeForTeachers($query)
    {
        return $query->where('applicable_for', 'teachers')
                     ->orWhere('applicable_for', 'both');
    }
}
