<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ItemStore extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'school_id',
        'store_name',
        'store_code',
        'location',
        'incharge_name',
        'incharge_phone',
        'incharge_email',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function stocks()
    {
        return $this->hasMany(ItemStock::class, 'store_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }
}
