<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Hostel extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'school_id',
        'name',
        'hostel_type',
        'address',
        'warden_name',
        'warden_phone',
        'warden_email',
        'total_rooms',
        'total_beds',
        'is_active',
    ];

    protected $casts = [
        'total_rooms' => 'integer',
        'total_beds' => 'integer',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function rooms()
    {
        return $this->hasMany(HostelRoom::class);
    }

    public function allocations()
    {
        return $this->hasMany(HostelAllocation::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('hostel_type', $type);
    }

    // Accessors
    public function getOccupiedBedsAttribute()
    {
        return $this->allocations()->where('is_active', true)->count();
    }

    public function getAvailableBedsAttribute()
    {
        return $this->total_beds - $this->occupied_beds;
    }
}
