<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class HomeworkEvaluation extends Model
{
    use HasFactory;

    protected $fillable = [
        'homework_id',
        'student_id',
        'submission_date',
        'submission_file',
        'marks_obtained',
        'total_marks',
        'feedback',
        'status',
        'evaluated_by',
        'evaluated_at',
    ];

    protected $casts = [
        'submission_date' => 'date',
        'marks_obtained' => 'decimal:2',
        'total_marks' => 'decimal:2',
        'evaluated_at' => 'datetime',
    ];

    // Relationships
    public function homework()
    {
        return $this->belongsTo(Homework::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function evaluatedBy()
    {
        return $this->belongsTo(User::class, 'evaluated_by');
    }

    // Scopes
    public function scopeEvaluated($query)
    {
        return $query->whereNotNull('evaluated_at');
    }

    public function scopePending($query)
    {
        return $query->whereNull('evaluated_at');
    }
}
