<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Homework extends Model
{
    use HasFactory;

    protected $fillable = [
        'class_id',
        'section_id',
        'subject_id',
        'title',
        'description',
        'homework_date',
        'submission_date',
        'attachments',
        'created_by',
    ];

    protected $casts = [
        'homework_date' => 'date',
        'submission_date' => 'date',
        'attachments' => 'array',
    ];

    // Relationships
    public function class()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }

    public function section()
    {
        return $this->belongsTo(Section::class);
    }

    public function subject()
    {
        return $this->belongsTo(Subject::class);
    }

    public function createdBy()
    {
        return $this->belongsTo(User::class, 'created_by');
    }

    public function evaluations()
    {
        return $this->hasMany(HomeworkEvaluation::class);
    }

    // Scopes
    public function scopeForClass($query, $classId)
    {
        return $query->where('class_id', $classId);
    }

    public function scopeOverdue($query)
    {
        return $query->where('submission_date', '<', now()->toDateString());
    }
}
