<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GradeSystem extends Model
{
    use HasFactory;

    protected $fillable = [
        'school_id',
        'name',
        'min_percentage',
        'max_percentage',
        'grade',
        'grade_point',
        'description',
        'is_active',
    ];

    protected $casts = [
        'min_percentage' => 'decimal:2',
        'max_percentage' => 'decimal:2',
        'grade_point' => 'decimal:2',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeForPercentage($query, $percentage)
    {
        return $query->where('min_percentage', '<=', $percentage)
                     ->where('max_percentage', '>=', $percentage);
    }

    // Static method to get grade for a percentage
    public static function getGradeForPercentage($schoolId, $percentage)
    {
        return self::where('school_id', $schoolId)
                   ->forPercentage($percentage)
                   ->active()
                   ->first();
    }
}
