<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class GeneratedCertificate extends Model
{
    use HasFactory;

    protected $fillable = [
        'certificate_template_id',
        'student_id',
        'certificate_number',
        'issue_date',
        'content',
        'file_path',
        'issued_by',
    ];

    protected $casts = [
        'issue_date' => 'date',
    ];

    // Relationships
    public function template()
    {
        return $this->belongsTo(CertificateTemplate::class, 'certificate_template_id');
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function issuedBy()
    {
        return $this->belongsTo(User::class, 'issued_by');
    }

    // Scopes
    public function scopeForStudent($query, $studentId)
    {
        return $query->where('student_id', $studentId);
    }
}
