<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeeGroupItem extends Model
{
    use HasFactory;

    protected $fillable = [
        'fee_group_id',
        'fee_head_id',
        'amount',
        'due_date',
        'is_optional',
    ];

    protected $casts = [
        'amount' => 'decimal:2',
        'due_date' => 'date',
        'is_optional' => 'boolean',
    ];

    // Relationships
    public function feeGroup()
    {
        return $this->belongsTo(FeeGroup::class);
    }

    public function feeHead()
    {
        return $this->belongsTo(FeeHead::class);
    }
}
