<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class FeeAllocation extends Model
{
    use HasFactory;

    protected $fillable = [
        'student_id',
        'fee_group_id',
        'academic_year_id',
        'allocated_date',
        'is_active',
    ];

    protected $casts = [
        'allocated_date' => 'date',
        'is_active' => 'boolean',
    ];

    // Relationships
    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    public function feeGroup()
    {
        return $this->belongsTo(FeeGroup::class);
    }

    public function academicYear()
    {
        return $this->belongsTo(AcademicYear::class);
    }

    public function transactions()
    {
        return $this->hasMany(FeeTransaction::class);
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    public function scopeForStudent($query, $studentId)
    {
        return $query->where('student_id', $studentId);
    }
}
