<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class ExpenseHead extends Model
{
    use HasFactory, SoftDeletes;

    protected $fillable = [
        'school_id',
        'head_name',
        'head_code',
        'description',
        'is_active',
    ];

    protected $casts = [
        'is_active' => 'boolean',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function expenses()
    {
        return $this->hasMany(Expense::class, 'expense_head_id');
    }

    // Scopes
    public function scopeActive($query)
    {
        return $query->where('is_active', true);
    }

    // Accessors
    public function getTotalExpensesAttribute()
    {
        return $this->expenses()->sum('amount');
    }
}
