<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class EventReminder extends Model
{
    use HasFactory;

    protected $fillable = [
        'school_id',
        'event_id',
        'reminder_type',
        'reminder_date',
        'reminder_time',
        'recipient_type',
        'recipient_ids',
        'message',
        'status',
        'sent_at',
    ];

    protected $casts = [
        'reminder_date' => 'date',
        'reminder_time' => 'datetime',
        'recipient_ids' => 'array',
        'sent_at' => 'datetime',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function event()
    {
        return $this->belongsTo(Event::class);
    }

    // Scopes
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeSent($query)
    {
        return $query->where('status', 'sent');
    }

    public function scopeDue($query)
    {
        return $query->where('status', 'pending')
                     ->where('reminder_time', '<=', now());
    }

    public function scopeByType($query, $type)
    {
        return $query->where('reminder_type', $type);
    }
}
