<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class DashboardWidget extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_id',
        'widget_name',
        'widget_type',
        'configuration',
        'position',
        'size',
        'is_visible',
    ];

    protected $casts = [
        'configuration' => 'array',
        'position' => 'integer',
        'is_visible' => 'boolean',
    ];

    // Relationships
    public function user()
    {
        return $this->belongsTo(User::class);
    }

    // Scopes
    public function scopeForUser($query, $userId)
    {
        return $query->where('user_id', $userId);
    }

    public function scopeVisible($query)
    {
        return $query->where('is_visible', true);
    }

    public function scopeByType($query, $type)
    {
        return $query->where('widget_type', $type);
    }

    public function scopeOrdered($query)
    {
        return $query->orderBy('position');
    }
}
