<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class AlumniGallery extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'alumni_gallery';

    protected $fillable = [
        'school_id',
        'event_id',
        'title',
        'description',
        'media_type',
        'file_path',
        'thumbnail_path',
        'uploaded_by',
    ];

    // Relationships
    public function school()
    {
        return $this->belongsTo(School::class);
    }

    public function event()
    {
        return $this->belongsTo(AlumniEvent::class, 'event_id');
    }

    public function uploadedBy()
    {
        return $this->belongsTo(User::class, 'uploaded_by');
    }

    // Scopes
    public function scopeForEvent($query, $eventId)
    {
        return $query->where('event_id', $eventId);
    }

    public function scopeByMediaType($query, $type)
    {
        return $query->where('media_type', $type);
    }

    public function scopeImages($query)
    {
        return $query->where('media_type', 'image');
    }

    public function scopeVideos($query)
    {
        return $query->where('media_type', 'video');
    }
}
