<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AlumniEventRegistration extends Model
{
    use HasFactory;

    protected $fillable = [
        'alumni_event_id',
        'alumni_id',
        'registration_date',
        'payment_status',
        'payment_date',
        'transaction_id',
        'attendance_status',
        'remarks',
    ];

    protected $casts = [
        'registration_date' => 'date',
        'payment_date' => 'date',
    ];

    // Relationships
    public function alumniEvent()
    {
        return $this->belongsTo(AlumniEvent::class, 'alumni_event_id');
    }

    public function alumni()
    {
        return $this->belongsTo(Alumni::class);
    }

    // Scopes
    public function scopeForEvent($query, $eventId)
    {
        return $query->where('alumni_event_id', $eventId);
    }

    public function scopeForAlumni($query, $alumniId)
    {
        return $query->where('alumni_id', $alumniId);
    }

    public function scopePaid($query)
    {
        return $query->where('payment_status', 'paid');
    }

    public function scopeAttended($query)
    {
        return $query->where('attendance_status', 'attended');
    }
}
