<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdmitCard extends Model
{
    use HasFactory;

    protected $fillable = [
        'exam_id',
        'student_id',
        'admit_card_number',
        'issued_date',
        'instructions',
        'is_issued',
    ];

    protected $casts = [
        'issued_date' => 'date',
        'is_issued' => 'boolean',
    ];

    // Relationships
    public function exam()
    {
        return $this->belongsTo(Exam::class);
    }

    public function student()
    {
        return $this->belongsTo(Student::class);
    }

    // Scopes
    public function scopeIssued($query)
    {
        return $query->where('is_issued', true);
    }

    public function scopeForExam($query, $examId)
    {
        return $query->where('exam_id', $examId);
    }
}
