<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class AdmissionEnquiry extends Model
{
    use HasFactory;

    protected $fillable = [
        'enquiry_date',
        'student_name',
        'date_of_birth',
        'gender',
        'class_id',
        'father_name',
        'father_phone',
        'father_email',
        'mother_name',
        'mother_phone',
        'mother_email',
        'address',
        'city',
        'state',
        'pincode',
        'previous_school',
        'reference_source',
        'status',
        'followup_date',
        'remarks',
        'assigned_to',
    ];

    protected $casts = [
        'enquiry_date' => 'date',
        'date_of_birth' => 'date',
        'followup_date' => 'date',
    ];

    // Relationships
    public function class()
    {
        return $this->belongsTo(SchoolClass::class, 'class_id');
    }

    public function assignedTo()
    {
        return $this->belongsTo(User::class, 'assigned_to');
    }

    // Scopes
    public function scopePending($query)
    {
        return $query->where('status', 'pending');
    }

    public function scopeConverted($query)
    {
        return $query->where('status', 'converted');
    }

    public function scopeFollowupDue($query)
    {
        return $query->where('followup_date', '<=', now())->where('status', 'pending');
    }
}
