<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\Student;

class CheckStudentAuth
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        if (!$request->user() instanceof Student) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized. Student access required.',
            ], 403);
        }

        if (!$request->user()->tokenCan('student')) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid token abilities.',
            ], 403);
        }

        return $next($request);
    }
}
