<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use App\Models\ParentModel;

class CheckParentAuth
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next)
    {
        if (!$request->user() instanceof ParentModel) {
            return response()->json([
                'success' => false,
                'message' => 'Unauthorized. Parent access required.',
            ], 403);
        }

        if (!$request->user()->tokenCan('parent')) {
            return response()->json([
                'success' => false,
                'message' => 'Invalid token abilities.',
            ], 403);
        }

        return $next($request);
    }
}
