# Model to Database Table Mapping

Total Models: **151**
Total Database Tables: **138**

## Complete Mapping

| # | Database Table | Model File | Description |
|---|---------------|------------|-------------|
| 1 | academic_boards | AcademicBoard.php | Academic board information |
| 2 | academic_years | AcademicYear.php | Academic year management |
| 3 | access_constraints | AccessConstraint.php | Access control restrictions |
| 4 | account_heads | AccountHead.php | Chart of accounts |
| 5 | activity_logs | ActivityLog.php | User activity tracking |
| 6 | admission_enquiries | AdmissionEnquiry.php | Admission inquiry management |
| 7 | admit_cards | AdmitCard.php | Exam admit cards |
| 8 | alumni | Alumni.php | Alumni database |
| 9 | alumni_event_registrations | AlumniEventRegistration.php | Event registrations |
| 10 | alumni_events | AlumniEvent.php | Alumni events |
| 11 | alumni_gallery | AlumniGallery.php | Event photos/videos |
| 12 | auth_tokens | AuthToken.php | API authentication tokens |
| 13 | backups | Backup.php | Backup management |
| 14 | book_categories | BookCategory.php | Library book categories |
| 15 | book_issues | BookIssue.php | Book issue tracking |
| 16 | book_reservations | BookReservation.php | Book reservations |
| 17 | budgets | Budget.php | Budget management |
| 18 | calendar_events | CalendarEvent.php | Calendar events |
| 19 | certificate_templates | CertificateTemplate.php | Certificate templates |
| 20 | class_subjects | ClassSubject.php | Class-subject mapping |
| 21 | class_teachers | ClassTeacher.php | Class teacher assignments |
| 22 | classes | SchoolClass.php | Class/grade management |
| 23 | complaints | Complaint.php | Complaint management |
| 24 | custom_reports | CustomReport.php | Custom report builder |
| 25 | dashboard_widgets | DashboardWidget.php | Dashboard widgets |
| 26 | departments | Department.php | Department management |
| 27 | designations | Designation.php | Staff designations |
| 28 | drivers | Driver.php | Transport drivers |
| 29 | email_logs | EmailLog.php | Email tracking |
| 30 | error_logs | ErrorLog.php | Error logging |
| 31 | event_reminders | EventReminder.php | Event reminders |
| 32 | exam_grades | GradeSystem.php | Grading system |
| 33 | exam_marks | Mark.php | Exam marks |
| 34 | exam_schedules | ExamSchedule.php | Exam scheduling |
| 35 | exams | Exam.php | Exam management |
| 36 | expense_heads | ExpenseHead.php | Expense categories |
| 37 | expenses | Expense.php | Expense tracking |
| 38 | fee_allocations | FeeAllocation.php | Student fee allocation |
| 39 | fee_discounts | FeeDiscount.php | Fee discounts |
| 40 | fee_group_items | FeeGroupItem.php | Fee group items |
| 41 | fee_groups | FeeGroup.php | Fee groups |
| 42 | fee_heads | FeeHead.php | Fee heads/types |
| 43 | fee_transactions | FeeTransaction.php | Fee payments |
| 44 | generated_certificates | GeneratedCertificate.php | Generated certificates |
| 45 | homework | Homework.php | Homework assignments |
| 46 | homework_evaluations | HomeworkEvaluation.php | Homework evaluation |
| 47 | hostel_allocations | HostelAllocation.php | Hostel room allocation |
| 48 | hostel_rooms | HostelRoom.php | Hostel rooms |
| 49 | hostels | Hostel.php | Hostel management |
| 50 | id_card_templates | IdCardTemplate.php | ID card templates |
| 51 | internal_messages | InternalMessage.php | Internal messaging |
| 52 | inventory_items | InventoryItem.php | Inventory catalog |
| 53 | item_categories | ItemCategory.php | Inventory categories |
| 54 | item_stock | ItemStock.php | Stock levels |
| 55 | item_stores | ItemStore.php | Store/warehouse |
| 56 | item_suppliers | ItemSupplier.php | Suppliers |
| 57 | kb_articles | KbArticle.php | Knowledge base |
| 58 | ledger_entries | LedgerEntry.php | Ledger entries |
| 59 | ledger_transactions | LedgerTransaction.php | Financial transactions |
| 60 | library_book_copies | LibraryBookCopy.php | Book copies |
| 61 | library_books | LibraryBook.php | Library books |
| 62 | lms_assignments | LmsAssignment.php | LMS assignments |
| 63 | lms_courses | LmsCourse.php | LMS courses |
| 64 | lms_lessons | LmsLesson.php | LMS lessons |
| 65 | lms_submissions | LmsSubmission.php | Assignment submissions |
| 66 | lms_topics | LmsTopic.php | Lesson topics |
| 67 | login_history | LoginHistory.php | Login tracking |
| 68 | message_templates | MessageTemplate.php | Message templates |
| 69 | migrations | - | Laravel migrations (skip) |
| 70 | notices | Notice.php | Notice board |
| 71 | online_exam_questions | OnlineExamQuestion.php | Online exam questions |
| 72 | online_exams | OnlineExam.php | Online exams |
| 73 | parent_feedback | ParentFeedback.php | Parent feedback |
| 74 | parent_meetings | ParentMeeting.php | Parent meetings |
| 75 | password_resets | - | Laravel default (skip) |
| 76 | payroll_statutory_settings | PayrollStatutorySetting.php | Payroll settings |
| 77 | payslip_items | PayslipItem.php | Payslip components |
| 78 | payslips | Payslip.php | Payslips |
| 79 | permission_groups | PermissionGroup.php | Permission groups |
| 80 | permissions | Permission.php | Permissions |
| 81 | phone_call_logs | PhoneCallLog.php | Call logs |
| 82 | postal_records | PostalRecord.php | Postal records |
| 83 | push_notifications | PushNotification.php | Push notifications |
| 84 | question_bank | QuestionBank.php | Question repository |
| 85 | question_options | QuestionOption.php | MCQ options |
| 86 | role_permissions | RolePermission.php | Role-permission mapping |
| 87 | roles | Role.php | User roles |
| 88 | room_types | RoomType.php | Hostel room types |
| 89 | route_stops | RouteStop.php | Transport stops |
| 90 | salary_heads | SalaryHead.php | Salary components |
| 91 | salary_template_details | SalaryTemplateDetail.php | Template details |
| 92 | salary_templates | SalaryTemplate.php | Salary templates |
| 93 | scheduled_reports | ScheduledReport.php | Report scheduling |
| 94 | school_profile | School.php | School information |
| 95 | sections | Section.php | Class sections |
| 96 | sms_logs | SmsLog.php | SMS tracking |
| 97 | sports | Sport.php | Sports catalog |
| 98 | sports_achievements | SportsAchievement.php | Sports achievements |
| 99 | sports_coaches | SportsCoach.php | Sports coaches |
| 100 | sports_matches | SportsMatch.php | Sports matches |
| 101 | sports_players | SportsPlayer.php | Sports players |
| 102 | sports_teams | SportsTeam.php | Sports teams |
| 103 | sports_tournaments | SportsTournament.php | Tournaments |
| 104 | staff | Staff.php | Staff management |
| 105 | staff_attendance | StaffAttendance.php | Staff attendance |
| 106 | staff_documents | StaffDocument.php | Staff documents |
| 107 | staff_leaves | StaffLeave.php | Staff leaves |
| 108 | staff_qualifications | StaffQualification.php | Staff qualifications |
| 109 | staff_salary_structure | StaffSalaryStructure.php | Salary structure |
| 110 | staff_tax_declarations | StaffTaxDeclaration.php | Tax declarations |
| 111 | stock_additions | StockAddition.php | Stock purchases |
| 112 | stock_issues | StockIssue.php | Stock issues |
| 113 | student_addresses | StudentAddress.php | Student addresses |
| 114 | student_attendance | StudentAttendance.php | Student attendance |
| 115 | student_documents | StudentDocument.php | Student documents |
| 116 | student_fitness_records | StudentFitnessRecord.php | Fitness records |
| 117 | student_leaves | StudentLeave.php | Student leaves |
| 118 | student_parents | ParentModel.php | Parent information |
| 119 | student_promotions | StudentPromotion.php | Class promotions |
| 120 | student_transport | StudentTransport.php | Transport allocation |
| 121 | students | Student.php | Student management |
| 122 | subjects | Subject.php | Subject management |
| 123 | support_categories | SupportCategory.php | Support categories |
| 124 | support_tickets | SupportTicket.php | Support tickets |
| 125 | system_audit_logs | SystemAuditLog.php | Audit trail |
| 126 | system_preferences | SystemPreference.php | System settings |
| 127 | teacher_lesson_plans | TeacherLessonPlan.php | Lesson plans |
| 128 | teacher_lesson_topics | TeacherLessonTopic.php | Lesson topics |
| 129 | teacher_resources | TeacherResource.php | Teaching resources |
| 130 | team_players | TeamPlayer.php | Team-player mapping |
| 131 | ticket_replies | TicketReply.php | Ticket replies |
| 132 | timetables | Timetable.php | Timetables |
| 133 | transport_routes | TransportRoute.php | Transport routes |
| 134 | user_roles | UserRole.php | User-role mapping |
| 135 | users | User.php | User management |
| 136 | vehicle_tracking_logs | VehicleTrackingLog.php | Vehicle tracking |
| 137 | vehicles | Vehicle.php | Vehicle management |
| 138 | visitors | Visitor.php | Visitor management |

## Additional Models Created

These models support the main functionality:
- **Book.php** - Generic book model (use LibraryBook.php for library)
- **Bus.php**, **BusRoute.php**, **BusAssignment.php** - Original transport models
- **Event.php**, **EventParticipant.php** - Generic events
- **FeePayment.php**, **FeeStructure.php**, **FeeType.php** - Legacy fee models
- **Message.php** - Generic messaging
- **Period.php** - Timetable periods
- **Teacher.php**, **TeacherAttendance.php** - Teacher models (staff table covers teachers)

## Models by Category

### Academic (15 models)
AcademicBoard, AcademicYear, SchoolClass, Section, Subject, ClassSubject, ClassTeacher, Exam, ExamSchedule, Mark, GradeSystem, AdmitCard, Homework, HomeworkEvaluation, Timetable

### Student Management (10 models)
Student, StudentAttendance, StudentAddress, StudentDocument, StudentLeave, StudentPromotion, StudentTransport, StudentFitnessRecord, ParentModel, AdmissionEnquiry

### Staff/Teacher (13 models)
Staff, Teacher, StaffAttendance, TeacherAttendance, StaffDocument, StaffQualification, StaffLeave, StaffSalaryStructure, StaffTaxDeclaration, Department, Designation, TeacherLessonPlan, TeacherResource

### Fee Management (10 models)
FeeGroup, FeeGroupItem, FeeHead, FeeAllocation, FeeTransaction, FeeDiscount, FeePayment, FeeStructure, FeeType

### LMS & Online Exam (9 models)
LmsCourse, LmsLesson, LmsTopic, LmsAssignment, LmsSubmission, OnlineExam, OnlineExamQuestion, QuestionBank, QuestionOption

### Library (5 models)
LibraryBook, LibraryBookCopy, BookIssue, BookReservation, BookCategory

### Transport (7 models)
Vehicle, Driver, TransportRoute, RouteStop, StudentTransport, VehicleTrackingLog, Bus

### Hostel (4 models)
Hostel, HostelRoom, HostelAllocation, RoomType

### Sports (9 models)
Sport, SportsTeam, SportsPlayer, SportsCoach, SportsMatch, SportsTournament, SportsAchievement, TeamPlayer

### Alumni (4 models)
Alumni, AlumniEvent, AlumniEventRegistration, AlumniGallery

### Inventory & Finance (13 models)
InventoryItem, ItemCategory, ItemStore, ItemSupplier, ItemStock, StockAddition, StockIssue, AccountHead, LedgerEntry, LedgerTransaction, Budget, Expense, ExpenseHead

### Payroll (6 models)
SalaryTemplate, SalaryTemplateDetail, SalaryHead, Payslip, PayslipItem, PayrollStatutorySetting

### Communication (11 models)
Notice, Announcement, Message, InternalMessage, MessageTemplate, EmailLog, SmsLog, PushNotification, PhoneCallLog, PostalRecord, EventReminder

### Support System (5 models)
SupportTicket, SupportCategory, TicketReply, Complaint, Visitor

### Events & Calendar (4 models)
CalendarEvent, Event, EventParticipant, EventReminder

### Certificates & Templates (3 models)
CertificateTemplate, GeneratedCertificate, IdCardTemplate

### System & Security (13 models)
User, Role, Permission, RolePermission, UserRole, AccessConstraint, PermissionGroup, AuthToken, LoginHistory, ActivityLog, ErrorLog, SystemAuditLog, SystemPreference

### Reports & Admin (5 models)
CustomReport, ScheduledReport, DashboardWidget, KbArticle, Backup

### Parent Relations (2 models)
ParentMeeting, ParentFeedback

## Key Features

All models include:
✅ Full CRUD capabilities
✅ Eloquent relationships (belongsTo, hasMany, belongsToMany)
✅ Query scopes for filtering
✅ Data type casting
✅ SoftDeletes where appropriate
✅ Accessor/Mutator methods
✅ Business logic methods
✅ Comprehensive field definitions

## Next Steps

1. **Create Migrations**: Generate migrations for all tables
2. **Create Controllers**: Build API controllers for CRUD operations
3. **Define Routes**: Set up API routes
4. **Add Validation**: Create Form Request classes
5. **Build Seeders**: Create database seeders for testing
6. **API Documentation**: Document all endpoints
7. **Write Tests**: Unit and feature tests

Your School ERP API is now equipped with a complete model layer covering all 138 database tables!
