# School ERP API Documentation

## Table of Contents
1. [Authentication](#authentication)
2. [Student Management](#student-management)
3. [Teacher Management](#teacher-management)
4. [Class Management](#class-management)
5. [Exam Management](#exam-management)
6. [Fee Management](#fee-management)
7. [Attendance Management](#attendance-management)
8. [Timetable Management](#timetable-management)
9. [Library Management](#library-management)
10. [Transport Management](#transport-management)
11. [Hostel Management](#hostel-management)
12. [Notice & Announcements](#notice--announcements)
13. [Communication](#communication)
14. [Reports](#reports)
15. [Settings](#settings)
16. [User & Role Management](#user--role-management)
17. [Dashboard](#dashboard)

---

## Base URL
```
http://localhost:8000/api/admin
```

---

## Authentication

### Headers Required for Protected Routes
```http
Authorization: Bearer {jwt_token}
Content-Type: application/json
Accept: application/json
```

### 1. Register Admin/User

**Endpoint:** `POST /register`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/register \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "name": "John Doe",
    "email": "john@example.com",
    "password": "password123",
    "password_confirmation": "password123",
    "phone": "+1234567890",
    "role_type": "admin"
  }'
```

**Request Body:**
```json
{
  "name": "John Doe",
  "email": "john@example.com",
  "password": "password123",
  "password_confirmation": "password123",
  "phone": "+1234567890",
  "role_type": "admin"
}
```

**Response (201 Created):**
```json
{
  "success": true,
  "message": "User registered successfully",
  "data": {
    "user": {
      "id": 1,
      "name": "John Doe",
      "email": "john@example.com",
      "phone": "+1234567890",
      "role_type": "admin",
      "is_active": true,
      "created_at": "2024-01-29T10:00:00.000000Z"
    },
    "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...",
    "token_type": "Bearer",
    "expires_in": 3600
  }
}
```

### 2. Login

**Endpoint:** `POST /login`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/login \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "email": "john@example.com",
    "password": "password123"
  }'
```

**Request Body:**
```json
{
  "email": "john@example.com",
  "password": "password123"
}
```

**Response (200 OK):**
```json
{
  "success": true,
  "message": "Login successful",
  "data": {
    "user": {
      "id": 1,
      "name": "John Doe",
      "email": "john@example.com",
      "phone": "+1234567890",
      "role_type": "admin",
      "is_active": true,
      "roles": []
    },
    "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...",
    "token_type": "Bearer",
    "expires_in": 3600
  }
}
```

### 3. Get Profile

**Endpoint:** `GET /profile`

**Request:**
```bash
curl -X GET http://localhost:8000/api/admin/profile \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "id": 1,
    "name": "John Doe",
    "email": "john@example.com",
    "phone": "+1234567890",
    "role_type": "admin",
    "is_active": true,
    "roles": []
  }
}
```

### 4. Refresh Token

**Endpoint:** `POST /refresh`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/refresh \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "token": "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9...",
  "token_type": "Bearer",
  "expires_in": 3600
}
```

### 5. Logout

**Endpoint:** `POST /logout`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/logout \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "message": "Logged out successfully"
}
```

---

## Student Management

### 1. List Students

**Endpoint:** `GET /students`

**Query Parameters:**
- `per_page` (integer, default: 15) - Items per page
- `search` (string) - Search by name, admission number, roll number
- `class_id` (integer) - Filter by class
- `section_id` (integer) - Filter by section
- `gender` (string) - Filter by gender (male, female, other)
- `is_active` (boolean) - Filter by active status
- `sort_by` (string) - Sort field
- `sort_order` (string) - Sort order (asc, desc)

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/students?per_page=20&search=john&class_id=1&sort_by=roll_number&sort_order=asc" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": [
    {
      "id": 1,
      "admission_number": "STU2024001",
      "roll_number": "001",
      "first_name": "John",
      "last_name": "Doe",
      "full_name": "John Doe",
      "date_of_birth": "2010-05-15",
      "gender": "male",
      "email": "john.student@example.com",
      "phone": "+1234567890",
      "class": {
        "id": 1,
        "name": "Class 10"
      },
      "section": {
        "id": 1,
        "name": "A"
      },
      "is_active": true,
      "created_at": "2024-01-15T10:00:00.000000Z"
    }
  ],
  "pagination": {
    "total": 150,
    "per_page": 20,
    "current_page": 1,
    "last_page": 8,
    "from": 1,
    "to": 20
  }
}
```

### 2. Create Student

**Endpoint:** `POST /students`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/students \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "school_id": 1,
    "academic_year_id": 1,
    "class_id": 1,
    "section_id": 1,
    "admission_number": "STU2024001",
    "roll_number": "001",
    "first_name": "John",
    "last_name": "Doe",
    "date_of_birth": "2010-05-15",
    "gender": "male",
    "blood_group": "O+",
    "email": "john.student@example.com",
    "password": "password123",
    "phone": "+1234567890",
    "address": "123 Main St",
    "city": "New York",
    "state": "NY",
    "country": "USA",
    "pincode": "10001",
    "admission_date": "2024-01-15",
    "emergency_contact_name": "Jane Doe",
    "emergency_contact_phone": "+1234567891",
    "father_name": "Robert Doe",
    "father_phone": "+1234567892",
    "mother_name": "Mary Doe",
    "mother_phone": "+1234567893",
    "is_active": true
  }'
```

**Response (201 Created):**
```json
{
  "success": true,
  "message": "Student created successfully",
  "data": {
    "id": 1,
    "admission_number": "STU2024001",
    "roll_number": "001",
    "first_name": "John",
    "last_name": "Doe",
    "class": {
      "id": 1,
      "name": "Class 10"
    },
    "section": {
      "id": 1,
      "name": "A"
    },
    "created_at": "2024-01-29T10:00:00.000000Z"
  }
}
```

### 3. Get Student Details

**Endpoint:** `GET /students/{id}`

**Request:**
```bash
curl -X GET http://localhost:8000/api/admin/students/1 \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "id": 1,
    "admission_number": "STU2024001",
    "roll_number": "001",
    "first_name": "John",
    "last_name": "Doe",
    "full_name": "John Doe",
    "date_of_birth": "2010-05-15",
    "age": 13,
    "gender": "male",
    "blood_group": "O+",
    "email": "john.student@example.com",
    "phone": "+1234567890",
    "address": "123 Main St",
    "city": "New York",
    "class": {
      "id": 1,
      "name": "Class 10"
    },
    "section": {
      "id": 1,
      "name": "A"
    },
    "parents": [],
    "bus_assignment": null,
    "hostel_allocation": null
  }
}
```

### 4. Update Student

**Endpoint:** `PUT /students/{id}`

**Request:**
```bash
curl -X PUT http://localhost:8000/api/admin/students/1 \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "first_name": "John Updated",
    "phone": "+1234567899",
    "is_active": true
  }'
```

**Response (200 OK):**
```json
{
  "success": true,
  "message": "Student updated successfully",
  "data": {
    "id": 1,
    "first_name": "John Updated",
    "last_name": "Doe",
    "phone": "+1234567899"
  }
}
```

### 5. Delete Student

**Endpoint:** `DELETE /students/{id}`

**Request:**
```bash
curl -X DELETE http://localhost:8000/api/admin/students/1 \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "message": "Student deleted successfully"
}
```

### 6. Get Student Attendance

**Endpoint:** `GET /students/{id}/attendance`

**Query Parameters:**
- `per_page` (integer) - Items per page
- `start_date` (date) - Start date filter
- `end_date` (date) - End date filter

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/students/1/attendance?start_date=2024-01-01&end_date=2024-01-31" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": [
    {
      "id": 1,
      "date": "2024-01-29",
      "status": "present",
      "remarks": null
    }
  ],
  "attendance_percentage": 95.5,
  "pagination": {
    "total": 20,
    "per_page": 15,
    "current_page": 1,
    "last_page": 2
  }
}
```

### 7. Get Student Marks

**Endpoint:** `GET /students/{id}/marks`

**Query Parameters:**
- `per_page` (integer) - Items per page
- `exam_id` (integer) - Filter by exam

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/students/1/marks?exam_id=1" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": [
    {
      "id": 1,
      "exam": {
        "id": 1,
        "name": "Mid Term Exam"
      },
      "subject": {
        "id": 1,
        "name": "Mathematics"
      },
      "marks_obtained": 85,
      "total_marks": 100,
      "percentage": 85.00
    }
  ],
  "pagination": {
    "total": 5,
    "per_page": 15,
    "current_page": 1,
    "last_page": 1
  }
}
```

---

## Dashboard

### Get Dashboard Statistics

**Endpoint:** `GET /dashboard`

**Query Parameters:**
- `school_id` (integer) - Filter by school
- `start_date` (date) - Period start date
- `end_date` (date) - Period end date

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/dashboard?school_id=1&start_date=2024-01-01&end_date=2024-01-31" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "students": {
      "total": 500,
      "active": 480,
      "male": 280,
      "female": 220
    },
    "teachers": {
      "total": 50,
      "active": 48
    },
    "staff": {
      "total": 20
    },
    "attendance": {
      "total": 12000,
      "present": 11400,
      "absent": 600,
      "percentage": 95.00,
      "period": {
        "start_date": "2024-01-01",
        "end_date": "2024-01-31"
      }
    },
    "fees": {
      "total_collected": 250000,
      "total_transactions": 450,
      "period": {
        "start_date": "2024-01-01",
        "end_date": "2024-01-31"
      }
    },
    "recent_notices": [],
    "upcoming_exams": [],
    "class_distribution": []
  }
}
```

---

## Fee Management

### 1. Create Fee Transaction

**Endpoint:** `POST /fee-transactions`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/fee-transactions \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "student_id": 1,
    "fee_structure_id": 1,
    "amount_due": 5000,
    "amount_paid": 5000,
    "discount_amount": 0,
    "fine_amount": 0,
    "payment_date": "2024-01-29",
    "payment_method": "cash",
    "payment_status": "paid",
    "receipt_number": "REC2024001",
    "remarks": "Full payment"
  }'
```

**Response (201 Created):**
```json
{
  "success": true,
  "message": "Fee transaction created successfully",
  "data": {
    "id": 1,
    "student_id": 1,
    "receipt_number": "REC2024001",
    "amount_paid": 5000,
    "payment_status": "paid",
    "payment_method": "cash",
    "payment_date": "2024-01-29",
    "student": {
      "id": 1,
      "name": "John Doe"
    }
  }
}
```

### 2. Get Fee Reports

**Endpoint:** `GET /fee-reports`

**Query Parameters:**
- `report_type` (required) - Type: summary, detailed, class_wise, defaulters, collection
- `start_date` (required) - Period start
- `end_date` (required) - Period end
- `class_id` (optional) - Filter by class
- `section_id` (optional) - Filter by section

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/fee-reports?report_type=summary&start_date=2024-01-01&end_date=2024-12-31" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "summary": {
      "total_transactions": 450,
      "total_amount_due": 2250000,
      "total_amount_paid": 2100000,
      "total_balance": 150000,
      "total_discount": 50000,
      "total_fine": 10000,
      "collection_percentage": 93.33
    },
    "payment_methods": [
      {
        "payment_method": "cash",
        "count": 200,
        "total": 1000000
      },
      {
        "payment_method": "online",
        "count": 250,
        "total": 1100000
      }
    ],
    "payment_status": [
      {
        "payment_status": "paid",
        "count": 400,
        "total": 2000000
      },
      {
        "payment_status": "partial",
        "count": 50,
        "total": 100000
      }
    ]
  }
}
```

---

## Attendance Management

### 1. Mark Attendance

**Endpoint:** `POST /attendance/mark`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/attendance/mark \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "date": "2024-01-29",
    "class_id": 1,
    "section_id": 1,
    "attendances": [
      {
        "student_id": 1,
        "status": "present",
        "remarks": null
      },
      {
        "student_id": 2,
        "status": "absent",
        "remarks": "Sick leave"
      }
    ]
  }'
```

**Response (201 Created):**
```json
{
  "success": true,
  "message": "Attendance marked successfully",
  "data": [
    {
      "id": 1,
      "student_id": 1,
      "date": "2024-01-29",
      "status": "present"
    },
    {
      "id": 2,
      "student_id": 2,
      "date": "2024-01-29",
      "status": "absent",
      "remarks": "Sick leave"
    }
  ]
}
```

### 2. Get Attendance Statistics

**Endpoint:** `GET /attendance/statistics`

**Query Parameters:**
- `start_date` (required) - Period start
- `end_date` (required) - Period end
- `class_id` (optional) - Filter by class
- `section_id` (optional) - Filter by section

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/attendance/statistics?start_date=2024-01-01&end_date=2024-01-31&class_id=1" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "total": 600,
    "present": 570,
    "absent": 25,
    "late": 3,
    "excused": 2,
    "attendance_percentage": 95.00
  }
}
```

---

## Timetable Management

### 1. Create Timetable Entry

**Endpoint:** `POST /timetables`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/timetables \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "academic_year_id": 1,
    "class_id": 1,
    "section_id": 1,
    "subject_id": 1,
    "teacher_id": 1,
    "period_id": 1,
    "day_of_week": "monday",
    "room_number": "101"
  }'
```

**Response (201 Created):**
```json
{
  "success": true,
  "message": "Timetable entry created successfully",
  "data": {
    "id": 1,
    "day_of_week": "monday",
    "period": {
      "id": 1,
      "name": "Period 1",
      "start_time": "08:00",
      "end_time": "09:00"
    },
    "subject": {
      "id": 1,
      "name": "Mathematics"
    },
    "teacher": {
      "id": 1,
      "name": "John Smith"
    },
    "room_number": "101"
  }
}
```

### 2. Get Weekly Timetable

**Endpoint:** `GET /timetables/weekly/view`

**Query Parameters:**
- `class_id` (required) - Class ID
- `section_id` (optional) - Section ID

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/timetables/weekly/view?class_id=1&section_id=1" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "weekly_timetable": {
      "monday": [
        {
          "period_id": 1,
          "period": {
            "name": "Period 1",
            "start_time": "08:00",
            "end_time": "09:00"
          },
          "subject": "Mathematics",
          "teacher": "John Smith",
          "room_number": "101"
        }
      ],
      "tuesday": [],
      "wednesday": []
    },
    "days": ["monday", "tuesday", "wednesday", "thursday", "friday", "saturday"]
  }
}
```

### 3. Check Conflict

**Endpoint:** `POST /timetables/conflict/check`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/timetables/conflict/check \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "class_id": 1,
    "section_id": 1,
    "day_of_week": "monday",
    "period_id": 1,
    "teacher_id": 1
  }'
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "has_conflict": false,
    "conflict_message": null
  }
}
```

---

## Reports

### 1. Student Reports

**Endpoint:** `GET /reports/students`

**Query Parameters:**
- `report_type` (required) - Type: list, performance, demographic, attendance_summary, fee_summary
- `class_id` (optional) - Filter by class
- `section_id` (optional) - Filter by section
- `start_date` (optional) - Period start
- `end_date` (optional) - Period end

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/reports/students?report_type=performance&class_id=1" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "students": [
      {
        "id": 1,
        "name": "John Doe",
        "roll_number": "001",
        "class": "Class 10",
        "section": "A",
        "total_marks": 425,
        "total_possible": 500,
        "percentage": 85.00,
        "exam_count": 5,
        "performance_grade": "A"
      }
    ],
    "summary": {
      "total_students": 30,
      "average_percentage": 78.5,
      "highest_percentage": 95.0,
      "lowest_percentage": 45.0
    }
  }
}
```

### 2. Attendance Reports

**Endpoint:** `GET /reports/attendance`

**Query Parameters:**
- `report_type` (required) - Type: daily, monthly, class_wise, student_wise, defaulters
- `date` (for daily) - Date
- `start_date` (for others) - Period start
- `end_date` (for others) - Period end
- `student_id` (for student_wise) - Student ID
- `class_id` (optional) - Filter by class

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/reports/attendance?report_type=monthly&start_date=2024-01-01&end_date=2024-01-31" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "daily_breakdown": [
      {
        "date": "2024-01-01",
        "total": 500,
        "present": 480,
        "absent": 15,
        "late": 5
      }
    ],
    "period": {
      "start_date": "2024-01-01",
      "end_date": "2024-01-31"
    },
    "summary": {
      "total_records": 12000,
      "total_present": 11400,
      "total_absent": 600,
      "overall_percentage": 95.00
    }
  }
}
```

### 3. Exam Results Reports

**Endpoint:** `GET /reports/exam-results`

**Query Parameters:**
- `report_type` (required) - Type: exam_wise, student_wise, class_wise, subject_wise, toppers, failures
- `exam_id` (required for most types) - Exam ID
- `student_id` (for student_wise) - Student ID
- `limit` (for toppers) - Number of toppers

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/reports/exam-results?report_type=toppers&exam_id=1&limit=10" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "toppers": [
      {
        "student_id": 1,
        "name": "John Doe",
        "roll_number": "001",
        "class": "Class 10",
        "section": "A",
        "total_obtained": 475,
        "total_marks": 500,
        "percentage": 95.00,
        "grade": "A+"
      }
    ],
    "limit": 10
  }
}
```

---

## Communication

### 1. Send SMS

**Endpoint:** `POST /send-sms`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/send-sms \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "recipient_type": "students",
    "message": "Reminder: Exam starts tomorrow",
    "class_id": 1,
    "section_id": 1
  }'
```

**Response (200 OK):**
```json
{
  "success": true,
  "message": "SMS processed successfully",
  "data": {
    "total_recipients": 30,
    "status": "sent",
    "recipients": ["+1234567890", "+1234567891"]
  }
}
```

### 2. Send Email

**Endpoint:** `POST /send-email`

**Request:**
```bash
curl -X POST http://localhost:8000/api/admin/send-email \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "recipient_type": "teachers",
    "subject": "Monthly Meeting",
    "message": "Please attend the monthly meeting on Friday.",
    "attachments": []
  }'
```

**Response (200 OK):**
```json
{
  "success": true,
  "message": "Email processed successfully",
  "data": {
    "total_recipients": 50,
    "status": "sent",
    "recipients": ["teacher1@example.com", "teacher2@example.com"]
  }
}
```

---

## Settings

### 1. Get Settings

**Endpoint:** `GET /settings`

**Query Parameters:**
- `category` (optional) - Category: general, academic, fee, notification, etc.

**Request:**
```bash
curl -X GET "http://localhost:8000/api/admin/settings?category=general" \
  -H "Authorization: Bearer {token}" \
  -H "Accept: application/json"
```

**Response (200 OK):**
```json
{
  "success": true,
  "data": {
    "category": "general",
    "settings": {
      "school_name": "School ERP System",
      "school_code": "SCH001",
      "email": "info@school.com",
      "phone": "+1234567890",
      "timezone": "UTC",
      "currency": "USD"
    }
  }
}
```

### 2. Update Settings

**Endpoint:** `PUT /settings`

**Request:**
```bash
curl -X PUT http://localhost:8000/api/admin/settings \
  -H "Authorization: Bearer {token}" \
  -H "Content-Type: application/json" \
  -H "Accept: application/json" \
  -d '{
    "category": "general",
    "settings": {
      "school_name": "Updated School Name",
      "timezone": "America/New_York"
    }
  }'
```

**Response (200 OK):**
```json
{
  "success": true,
  "message": "Settings updated successfully",
  "data": {
    "category": "general",
    "settings": {
      "school_name": "Updated School Name",
      "timezone": "America/New_York"
    }
  }
}
```

---

## Common Response Codes

| Code | Description |
|------|-------------|
| 200 | OK - Request successful |
| 201 | Created - Resource created successfully |
| 400 | Bad Request - Invalid request data |
| 401 | Unauthorized - Authentication required or failed |
| 403 | Forbidden - User doesn't have permission |
| 404 | Not Found - Resource not found |
| 422 | Validation Error - Request validation failed |
| 500 | Internal Server Error - Server error |

---

## Error Response Format

```json
{
  "success": false,
  "message": "Error message here",
  "errors": {
    "field_name": [
      "Error detail message"
    ]
  }
}
```

---

## Pagination

All list endpoints support pagination with the following response structure:

```json
{
  "success": true,
  "data": [],
  "pagination": {
    "total": 150,
    "per_page": 15,
    "current_page": 1,
    "last_page": 10,
    "from": 1,
    "to": 15
  }
}
```

---

## Search & Filtering

Most list endpoints support:
- `search` - Full-text search across relevant fields
- `sort_by` - Field to sort by
- `sort_order` - Sort direction (asc, desc)
- Resource-specific filters (class_id, section_id, status, etc.)

---

## Rate Limiting

API requests are rate-limited to prevent abuse. Current limits:
- 60 requests per minute for authenticated users
- 10 requests per minute for unauthenticated users

---

## API Versioning

Current API Version: **v1**

The API version is included in the base URL: `/api/admin/`

---

For complete API endpoint list and more examples, visit the [GitHub Repository](https://github.com/your-repo/school-erp-api)
